<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for CategoryOrganisations
 */
class CategoryOrganisationRepository extends Repository
{
    protected $defaultOrderings = [
        'coName' => QueryInterface::ORDER_ASCENDING,
    ];
    
    public function findByLimitToTypeOrNull($type)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('limitToType', $type), $query->equals('limitToType', null)];
        $query->matching($query->logicalOr(...$constraints));
        return $query->execute();
    }
}
