<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Certificates
 */
class CertificateRepository extends Repository
{
    protected $defaultOrderings = [
        'sorting' => QueryInterface::ORDER_ASCENDING,
        'name' => QueryInterface::ORDER_ASCENDING,
    ];

    public function findByLimitToTypeOrNull($type)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('limitToType', $type), $query->equals('limitToType', null)];
        $query->matching($query->logicalOr(...$constraints));
        $query->setOrderings([
            'sorting' => QueryInterface::ORDER_ASCENDING,
        ]);
        return $query->execute();
    }
}
