<?php

declare(strict_types=1);

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for ContactContacts
 */
class ContactContactRepository extends Repository
{
    protected $defaultOrderings = [
        'organisation.me_companyname' => QueryInterface::ORDER_ASCENDING,
        'contact.me_lastname' => QueryInterface::ORDER_ASCENDING,
        'contact.me_firstname' => QueryInterface::ORDER_ASCENDING,
        'relationType.name' => QueryInterface::ORDER_ASCENDING,
        'relationFunction.name' => QueryInterface::ORDER_ASCENDING,
        'title' => QueryInterface::ORDER_ASCENDING,
    ];

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }
    public function findRelationByContact(array $personUids, bool $returnRawQueryResult = false)
    {
        $query = $this->createQuery();
        
        $query->matching($query->in('contact', $personUids));

        return $query->execute($returnRawQueryResult);
    }
}
