<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for ContactTag
 */
class ContactTagRepository extends Repository
{
    protected $tablename = 'tx_igscrm_domain_model_contacttag';

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findOneByContactTag($contact, $tag, $raw = false)
    {
        $query = $this->createQuery();
        $constraints = [
            $query->equals('contact', $contact), //is_object($contact) ? $contact->getUid() : $contact),
            $query->equals('tag', $tag),
        ];
        if (!empty($constraints)) {
            $query->matching($query->logicalAnd(...$constraints));
        }
        $res = $query->execute($raw);
        return $raw ? ($res[0] ?? false) : $res->getFirst();
    }
    public function findOneByContactTags($contact, array $tagroles)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('contact', $contact->getUid())];
        if (!empty($tagroles)) {
            $constraints[] = $query->in('tagrole', $tagroles);
        }
        if (!empty($constraints)) {
            $query->matching($query->logicalAnd(...$constraints));
        }
        $res = $query->execute();
        return $res->getFirst();
    }

    public function rawInsertUpdate(int $contact, int $tag, array $contactTag, int $tagRole = null)
    {
        if ($contact <= 0 || $tag <= 0) {
            return false;
        }
        $tagRole = (int) $tagRole ?: null;
        
        $querySettings = $this->createQuery()
->getQuerySettings();
        $storagePageIds = $querySettings->getStoragePageIds();

        
        //var_dump($frameworkConfiguration['persistence']['classes']);exit(0);
        // field1
        $values = [
            'contact' => $contact,
            'tag' => $tag,
            //'tagrole' => $tagRole,
            'tstamp' => time(),
            'crdate' => time(),
        ];
        foreach ($contactTag as $name => $value) {
            $values[strtolower($name)] = $value === '' ? null : $value;
        }
        if (!empty($storagePageIds)) {
            $values['pid'] = $storagePageIds[0];
        }
        // if ($tagRole === null) {delete ???}

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        $uid = $queryBuilder
            ->select('uid')
            ->from($this->tablename)
            ->where(
                $queryBuilder->expr()
->eq('contact', $contact),
                $queryBuilder->expr()
->eq('tag', $tag),
            )->executeQuery()
            ->fetchOne();
        if ($uid > 0) {
            // update or delete
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                $this->tablename
            );
            $queryBuilder
                ->update($this->tablename)
                ->where($queryBuilder->expr() ->eq('uid', $uid));
            foreach ($values as $name => $value) {
                $queryBuilder->set($name, $value);
            }
            $affectedRows = $queryBuilder->executeStatement();
            $action = 'update: ' . $uid;
        } else {
            // insert
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                $this->tablename
            );
            $queryBuilder
                ->insert($this->tablename)
                ->values($values)
                ->executeStatement();
            $conn = $queryBuilder->getConnection();
            $lastInsertId = $conn->lastInsertId();
            $action = 'insert: ' . $lastInsertId;
        }
        return $action;
    }
}
