<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\QueryBuilder;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for ContactVerbands
 */
class ContactVerbandRepository extends Repository
{
    protected $tablename = 'tx_igscrm_domain_model_contactverband';
    protected static $statisticsExcludedMemberships = null;
    public function createContactVerbandQueryBuilder()
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->tablename);
        return GeneralUtility::makeInstance(QueryBuilder::class, $conn);
    }
    public function getStatisticsExcludedMemberships()
    {
        if (static::$statisticsExcludedMemberships === null) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_igscrm_domain_model_mitgliedschaft'
            );
            $queryBuilder->select('uid')
                ->from('tx_igscrm_domain_model_mitgliedschaft')
                ->where('no_person=1');
            $res = $queryBuilder->executeQuery();
            static::$statisticsExcludedMemberships = $res->fetchFirstColumn();
        }
        return static::$statisticsExcludedMemberships;
    }

    public function getOrderBy($type)
    {
        if ($type == 'Organisation') {
            return [
                'contact.meCompanyname' => QueryInterface::ORDER_ASCENDING,
            ];
        }
        return [
            'contact.meLastname' => QueryInterface::ORDER_ASCENDING,
            'contact.meFirstname' => QueryInterface::ORDER_ASCENDING,
        ];
    }

    public function findEintritteByVerband($verband, $jahr, $type = 'Person')
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('verband', $verband),
                $query->equals('contact.type', $type),
                $query->equals('active', 1),
                $query->logicalAnd(
                    $query->greaterThanOrEqual('startDate', $jahr . '-01-01'),
                    $query->lessThanOrEqual('startDate', $jahr . '-12-31')
                )
            )
        );
        $orderBy = $this->getOrderBy($type);
        $query->setOrderings($orderBy);
        $return = $query->execute();
        return $return;
    }
    public function findGroupedEintritteByVerbandWithCertificates($verband, $jahr, $type = 'Person')
    {
        $queryBuilder = $this->createContactVerbandQueryBuilder();
        $queryBuilder
            ->from($this->tablename)
            ->join(
                $this->tablename,
                'tx_igscrm_domain_model_contact',
                'tx_igscrm_domain_model_contact',
                $queryBuilder->expr()
                    ->eq($this->tablename . '.contact', $queryBuilder->quoteIdentifier('tx_igscrm_domain_model_contact.uid'))
            )
            ->leftJoin(
                'tx_igscrm_domain_model_contact',
                'tx_igscrm_domain_model_contactcertificate',
                'tx_igscrm_domain_model_contactcertificate',
                $queryBuilder->expr()
                    ->eq(
                        'tx_igscrm_domain_model_contactcertificate.contact',
                        $queryBuilder->quoteIdentifier('tx_igscrm_domain_model_contact.uid')
                    )
            )
            ->leftJoin(
                'tx_igscrm_domain_model_contactcertificate',
                'tx_igscrm_domain_model_certificate',
                'tx_igscrm_domain_model_certificate',
                $queryBuilder->expr()
                    ->eq('certificate', $queryBuilder->quoteIdentifier('tx_igscrm_domain_model_certificate.uid'))
            )
            ->where(
                $queryBuilder->expr()
                    ->eq('verband', (int)$verband->getUid()),
                $queryBuilder->expr()
                    ->eq('active', 1),
                $queryBuilder->expr()
                    ->notIn(
                        'mitgliedschaft',
                        $queryBuilder->createNamedParameter($this->getStatisticsExcludedMemberships(), Connection::PARAM_INT_ARRAY)
                    ),
                $queryBuilder->expr()
                    ->and(
                        $queryBuilder->expr()
                            ->gte('start_date', $queryBuilder->createNamedParameter($jahr . '-01-01')),
                        $queryBuilder->expr()
                            ->lte('start_date', $queryBuilder->createNamedParameter($jahr . '-12-31'))
                    ),
                $queryBuilder->expr()
                    ->eq('type', $queryBuilder->createNamedParameter($type)), //tx_igscrm_domain_model_contact
            )
            ->select('tx_igscrm_domain_model_certificate.uid', 'tx_igscrm_domain_model_certificate.name')
            ->addSelectLiteral(
                'SUM(1) AS quantity'
                //$queryBuilder->expr()->count('*', 'anzahl')
            )
            ->groupBy('tx_igscrm_domain_model_certificate.uid', 'tx_igscrm_domain_model_certificate.name');

        /*
          $search = [];
          $replace = [];
          foreach( array_reverse($queryBuilder->getParameters(), true) as $key => $value) {
          $search[] = ':' . $key;
          $replace[] = is_int($value) ? $value : "'" . $value . "'";
          }$sql = str_replace($search, $replace, $queryBuilder->getSQL( )); // Debug SQL Query
          die($sql);
        */
        $res = $queryBuilder->executeQuery();

        return $res->fetchAllAssociative();
        //$d = $res->fetchAssociative();
    }

    public function findAustritteByVerband($verband, $jahr, $type = 'Person')
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('verband', $verband),
                //$query->equals('active', 0),
                $query->equals('contact.type', $type),
                $query->logicalAnd(
                    $query->greaterThanOrEqual('endDate', $jahr . '-01-01'),
                    $query->lessThanOrEqual('endDate', $jahr . '-12-31')
                ),
                $query->logicalOr(
                    $query->equals('contact.meVerstorben', 0),
                    $query->equals('contact.meTodestag', null)
                    //$query->logicalNot($query->greaterThanOrEqual('contact.meTodestag', '0000-00-00'))
                )
            )
        );
        $orderBy = $this->getOrderBy($type);
        $query->setOrderings($orderBy);
        $return = $query->execute();
        return $return;
    }
    public function findForOrganisation($organisationUid)
    {
        $query = $this->createQuery();
        $query->matching($query->contains('organisations', $organisationUid));
        $orderBy = [
            'contact.meLastname' => QueryInterface::ORDER_ASCENDING,
            'contact.meFirstname' => QueryInterface::ORDER_ASCENDING,
        ];
        $query->setOrderings($orderBy);
        $return = $query->execute();
        return $return;
    }
}
