<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Emailaddresses
 */
class EmailaddressRepository extends Repository
{
    public function findByPerson($person_uid)
    {
        $query = $this->createQuery();
        $query->matching($query->equals('ea_personid', $person_uid));
        //$query->setOrderings( array('ofCompanyname' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING));
        return $query->execute();
    }

    public function findByPersonAndCategory($person_uid, $cat_uid)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('ea_personid', $person_uid),
                $query->equals('ea_emailcategoryid', $cat_uid)
            )
        );
        return $query->execute();
    }
}
