<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use Internetgalerie\IgsCrm\Domain\Model\Kanton;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Kantons
 */
class KantonRepository extends AbstractCrmRepository
{
    protected $defaultOrderings = [
        'kaName' => QueryInterface::ORDER_ASCENDING,
    ];

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }
    public function findWithOrganisation()
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igscrm_domain_model_kanton'
        );
        $sql = "SELECT * FROM tx_igscrm_domain_model_kanton WHERE uid IN (SELECT me_kanton_id FROM tx_igscrm_domain_model_contact WHERE type='" . Organisation::class . "') ORDER BY ka_name;";
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery();
        $rows = $res->fetchAllAssociative();
        //$dataMapper = GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper::class);
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
        return $dataMapper->map(Kanton::class, $rows);
    }
    public function findBySearch(array $search)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectStoragePage(false);
        $searchConstrains = [];
        //$searchConstrains[] = $query->equals('verband', $search['verband'] ?? 0);
        if (!empty($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }
        return $query->execute(true);
    }
}
