<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Kursteilnehmers
 */
class KursteilnehmerRepository extends Repository
{
    /**
     * Template for a search logic query
     */
    public function findBySearchLogic(array $search = [], $orderRule = 'date')
    {
        // Create a Query Object
        $query = $this->createQuery();
        // FS
        $searchConstrains = [];
        if (isset($search['person']) && $search['person'] !== '') {
            $searchConstrains[] = $query->equals('ktPerson', intval($search['person']));
        }
        if (isset($search['year']) && $search['year'] !== '') {
            $searchConstrains[] = $query->logicalAnd(
                $query->greaterThanOrEqual('ktStartdatum', $search['year'] . '-01-01'),
                $query->lessThanOrEqual('ktStartdatum', $search['year'] . '-12-31')
            );
        }
        if (isset($search['keyword']) && $search['keyword'] !== '') {
            $searchConstrains[] = $query->logicalOr(
                $query->like('ktDauer', '%' . $search['keyword'] . '%'),
                $query->like('ktPerson.meLastname', '%' . $search['keyword'] . '%'),
                $query->like('ktPerson.meFirstname', '%' . $search['keyword'] . '%'),
                $query->like('ktKurse.kuName', '%' . $search['keyword'] . '%')
            );
        }
        if (count($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }

        // Set some Ordering.
        // array of (property => order) pairs
        if ($orderRule == 'person') {
            $orderBy = [
                'ktPerson.meLastname' => self::ORDER_ASC,
                'ktPerson.meFirstname' => self::ORDER_ASC,
                'ktStartdatum' => self::ORDER_ASC,
            ];
        } else {
            $orderBy = [
                'ktStartdatum' => self::ORDER_DESC,
                'ktPerson.meLastname' => self::ORDER_ASC,
                'ktPerson.meFirstname' => self::ORDER_ASC,
            ];
        }
        $query->setOrderings($orderBy);

        // override sorting by search headers
        // or manually by setting: extension_prefix[@sorting][property] = name & extension_prefix[@sorting][order] = 1
        //$this->initAutoSorting($query);

        //execute
        return $query->execute();
    }
}
