<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for Languages
 */
class LanguageRepository extends AbstractCrmRepository
{
    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }


    public function findBySearch(array $search)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectStoragePage(false);
        $searchConstrains = [];
        //$searchConstrains[] = $query->equals('verband', $search['verband'] ?? 0);
        if (isset($search['ids'])) {
            $ids = GeneralUtility::intExplode(',', $search['ids'], true);
            $searchConstrains[] = $query->in('uid', $ids);
        }
        if (!empty($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }
        return $query->execute(true);
    }
}
