<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Message
 */
class MessageRepository extends Repository
{
    protected $defaultOrderings = [
        'tstamp' => QueryInterface::ORDER_DESCENDING,
    ];


    public function findBySearch(array $search = [])
    {
        $query = $this->createQuery();
        $searchConstrains = [];
        if (isset($search['verband']) && 0) {
            $searchConstrains[] = $query->equals('verband', intval($search['verband']));
        }
        if (isset($search['contact']) && $search['contact'] != '') {
            $searchConstrains[] = $query->equals('contact', intval($search['contact']));
        }
        if (isset($search['keyword']) && $search['keyword'] != '') {
            $searchConstrains[] = $query->logicalOr(
                $query->like('title', '%' . $search['keyword'] . '%'),
                $query->like('content', '%' . $search['keyword'] . '%')
            );
        }
        if (!empty($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }
        $return = $query->execute();
        //die('anz='.$return->count());
        return $return;
    }
}
