<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

/**
 * The repository for Mitgliedschafts
 */
class MitgliedschaftRepository extends AbstractCrmRepository
{
    public function findByVerbandExcludedStatistik($verband, $excluded)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('verband', $verband), $query->equals('noPerson', $excluded)];
        $query->matching($query->logicalAnd(...$constraints));
        return $query->execute();
    }
    public function findByVerbandAndType($verband, $type)
    {
        $query = $this->createQuery();
        $constraints = [
            $query->equals('verband', $verband),
            $query->logicalOr($query->equals('limitToType', null), $query->equals('limitToType', $type)),
        ];
        $query->matching($query->logicalAnd(...$constraints));
        return $query->execute();
    }

    public function findBySearch(array $search)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectStoragePage(false);
        $searchConstrains = [];
        $searchConstrains[] = $query->equals('verband', $search['verband'] ?? 0);
        if (isset($search['noPerson'])) {
            $searchConstrains[] = $query->equals('noPerson', (int) $search['noPerson']);
        }
        if (isset($search['type'])) {
            $searchConstrains[] = $query->equals('limitToType', $search['type']);
        }
        if (!empty($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }
        return $query->execute(true);
    }
    
    public function findByUids(array $uids = [])
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectStoragePage(false);
        if (!empty($uids)) {
            $query->matching($query->in('verband', $uids));
        }
        
        return $query->execute();
    }
}
