<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;
use TYPO3\CMS\Core\Database\Connection;

use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use PDO;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Persistence\Generic\Storage\Typo3DbQueryParser;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Organisations
 */
class OrganisationRepository extends ContactRepository
{
    protected $type = 'Organisation';
    protected $objectType = Organisation::class;
    protected $useAcl = true;
    
    protected $apiAttributes = [
        'uid',
        'me_companyname',
        'me_addon',
        'me_address',
        'me_zip',
        'me_map',
        'me_city',
        'phone',
        'me_email',
        'me_url',
    ];
    protected $defaultOrderings = [
        'extraSorting' => QueryInterface::ORDER_ASCENDING,
        'meCompanyname' => QueryInterface::ORDER_ASCENDING,
        'meLastname' => QueryInterface::ORDER_ASCENDING,
        'meFirstname' => QueryInterface::ORDER_ASCENDING,
    ];

    /**
     * is needed for update at least in TYPO3 11 for organisation(19.5.2023)
     */
    public function initializeObject(): void
    {
        $this->type = 'Organisation';
        $this->objectType = Organisation::class;
    }
    
    public function findBySearch(array $search = [], $orderBy = [])
    {
        $search['type'] = 'Organisation';
        return parent::findBySearch($search, $orderBy);
    }
    
    public function getSqlBase($year = null)
    {
        $sql = 'tx_igscrm_domain_model_contact.deleted=0 AND tx_igscrm_domain_model_contact.hidden=0';
        if ($year === null) {
            $sql .= ' AND me_end IS NULL';
        } else {
            $sql .= " AND (me_end IS NULL OR me_end >= '" . (int) $year . "-01-01') AND (me_start IS NULL OR me_start<'" . (int) $year . "-12-31')";
        }
        return $sql;
    }
    public function rawByUid($uid)
    {
        $query = $this->createQuery();
        $query->matching($query->equals('uid', $uid));
        $queryParser = GeneralUtility::makeInstance(Typo3DbQueryParser::class);
        $queryBuilder = $queryParser->convertQueryToDoctrineQueryBuilder($query);
        $queryBuilder->select('uid', 'me_companyname', 'me_addon', 'me_address', 'me_pobox', 'me_zip', 'me_city');
        //echo('Q='.$queryBuilder->getSql());exit(0);
        return $queryBuilder->executeQuery()
->fetchAssociative(); //->fetchAllAssociative();

        //$return = $query->execute(true); // raw
        //return $queryBuilder->select('identifier', 'content')->from('tx_igscrm_domain_model_contact')->where('uid' )->executeQuery()->fetchAssociative();
    }

    public function findFilialen(int $organisationUid)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                //$query->equals('meActive', 1),
                $query->equals('parent', $organisationUid)
            )
        );
        return $query->execute();
    }
    public function findRawFilialen(int $organisationUid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_contact'
        );
        $queryBuilder
            ->select('*')
            ->from('tx_igscrm_domain_model_contact');
        $res = $queryBuilder
             ->where(
                 $queryBuilder->expr()
->eq('parent', $queryBuilder->createNamedParameter($organisationUid, Connection::PARAM_INT)),
             )
             ->executeQuery();
        return $res->fetchAllAssociative();
    }
    public function findRawFilialenActive(int $organisationUid, int $verbandUid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_contact'
        );
        $queryBuilder
                ->select('*')
                ->from('tx_igscrm_domain_model_contact');
        $queryBuilder->join(
            $this->tablename,
            'tx_igscrm_domain_model_contactverband',
            'tx_igscrm_domain_model_contactverband',
            'tx_igscrm_domain_model_contactverband.contact = ' . $this->tablename . '.uid AND tx_igscrm_domain_model_contactverband.verband = ' . $verbandUid . ''
        );
        $res = $queryBuilder
        ->where(
            $queryBuilder->expr()
->and(
    $this->sqlActive(),
    /*
    $queryBuilder->expr()->eq(
        'me_active',
        1
    ),
    */
    $queryBuilder->expr()
->eq('parent', $queryBuilder->createNamedParameter($organisationUid, Connection::PARAM_INT))
)
        )
           ->executeQuery();
        return $res->fetchAllAssociative();
    }

    public function findUniqueEntry($companyname, $city, $zip)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('meActive', 1),
                $query->equals('meCompanyname', $companyname),
                $query->logicalOr($query->equals('meZip', $zip), $query->equals('meCity', $city))
            )
        );
        $entries = $query->execute();
        if ($entries->count() == 1) {
            return $entries->getFirst();
        }
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd($query->equals('meActive', 1), $query->equals('meCompanyname', $companyname))
        );
        $entries = $query->execute();

        if ($entries->count() == 1) {
            return $entries->getFirst();
        }
        return null;
    }
    public function findByFrontendUserAccess(int $frontendUserUid)
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igscrm_domain_model_contact'
        );
        $sqlUserPerson = 'SELECT uid  FROM tx_igscrm_domain_model_contact  where frontend_user=' . $frontendUserUid;
        $sql = "SELECT * FROM tx_igscrm_domain_model_contact WHERE type='Organisation'  AND EXISTS (SELECT 1 FROM tx_igscrm_organisation_categoryorganisation_mm WHERE uid_local=uid AND uid_foreign=1) AND EXISTS (SELECT 1 FROM tx_igscrm_domain_model_contactcontact WHERE organisation=tx_igscrm_domain_model_contact.uid AND contact IN (" . $sqlUserPerson . '));';
        return $conn->query($sql);
    }
    public function countByFrontendUserAccess(int $frontendUserUid)
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igscrm_domain_model_contact'
        );
        $sqlUserPerson = 'SELECT uid  FROM tx_igscrm_domain_model_contact  where frontend_user=' . $frontendUserUid;
        $sql = "SELECT count(1) FROM tx_igscrm_domain_model_contact WHERE type='Organisation'  AND EXISTS (SELECT 1 FROM tx_igscrm_organisation_categoryorganisation_mm WHERE uid_local=uid AND uid_foreign=1) AND EXISTS (SELECT 1 FROM tx_igscrm_domain_model_contactcontact WHERE organisation=tx_igscrm_domain_model_contact.uid AND contact IN (" . $sqlUserPerson . '));';
        $stmt = $conn->query($sql);
        return $stmt->fetchOne();
    }
    public function findByFrontendUserAccessAll(int $frontendUserUid)
    {
        $stmt = $this->findByFrontendUserAccess($frontendUserUid);
        $organisationsArray = $stmt->fetchAllAssociative();
        if (empty($organisationsArray)) {
            return [];
        }
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
        return $dataMapper->map($this->objectType, $organisationsArray);
    }
    
    public function findByFrontendUserAccessFirst(int $frontendUserUid)
    {
        $stmt = $this->findByFrontendUserAccess($frontendUserUid);
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
        $organisationArray = $stmt->fetchAssociative();
        if ($organisationArray === false) {
            return false;
        }
        $objectsArray = $dataMapper->map($this->objectType, [$organisationArray]);
        return $objectsArray[0];
    }

    
    public function findWithLetter($letter, $returnRawQueryResult)
    {
        $query = $this->createQuery();
        $query->matching($query->like('me_companyname', $letter . '%'));
        return $query->execute($returnRawQueryResult);
    }

    public function getMandatenUidWithProducts($searchProduct)
    {
        // Create a Query Object
        $query = $this->createQuery();
        if (count($searchProduct) > 0) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_igshop2_domain_model_product'
            );
            $kewords = GeneralUtility::trimExplode(' ', $searchProduct, true);
            foreach ($kewords as $keyword) {
                $constraints[] = $queryBuilder->expr()->or(
                    $queryBuilder->expr()->like(
                        'name',
                        $queryBuilder->createNamedParameter('%' . $queryBuilder->escapeLikeWildcards($keyword) . '%')
                    ),
                    $queryBuilder->expr()->like('description', $queryBuilder->createNamedParameter(
                        '%' . $queryBuilder->escapeLikeWildcards($keyword) . '%'
                    ))
                );
            }
            $constraints[] = 'mandant_uid != 0';
            $queryBuilder->select('mandant_uid')
->from('tx_igshop2_domain_model_product');

            $queryBuilder->where(...$constraints);
            //echo($queryBuilder->getSQL());exit;
            $rows = $queryBuilder->executeQuery()
                ->fetchAllAssociative();
            $uids = [];
            foreach ($rows as $row) {
                $uids[] = $row['mandant_uid'];
            }
            return $uids;
        }
    }
    public function findByFirstLetter(bool $returnRawQueryResult = false)
    {
        // Create a Query Object
        $query = $this->createQuery();

        $query->statement(
            'SELECT DISTINCT LEFT(me_companyname, 1) AS l FROM tx_igscrm_domain_model_contact WHERE me_companyname != "" ORDER BY me_companyname'
        );

        return $query->execute($returnRawQueryResult);
    }



    /**
     * Returns a query for objects of this repository
     *
     * @return QueryInterface
     */
    public function createQuery()
    {
        $query = $this->persistenceManager->createQueryForType($this->objectType);
        $query->matching($query->equals('type', $this->type));
        if ($this->defaultOrderings !== []) {
            $query->setOrderings($this->defaultOrderings);
        }
        if ($this->defaultQuerySettings !== null) {
            $query->setQuerySettings(clone $this->defaultQuerySettings);
        }
        return $query;
    }


    protected function getRepositoryClassName()
    {
        return PersonRepository::class;
    }
}
