<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use Internetgalerie\IgsCrm\Domain\Model\Person;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Persons
 */
class PersonRepository extends ContactRepository
{
    protected $tablename = 'tx_igscrm_domain_model_contact';
    protected $type = 'Person';
    protected $objectType = Person::class;

    protected $defaultOrderings = [
        'extraSorting' => QueryInterface::ORDER_ASCENDING,
        'meLastname' => QueryInterface::ORDER_ASCENDING,
        'meFirstname' => QueryInterface::ORDER_ASCENDING,
        'meCompanyname' => QueryInterface::ORDER_ASCENDING,
    ];

    /**
     * is needed for update at least in TYPO3 11 for organisation(19.5.2023)
     */
    public function initializeObject(): void
    {
        $this->type = 'Person';
        $this->objectType = Person::class;
    }


    public function findEmployeeByTenant($tenant = null)
    {
        $queryBuilder = $this->createContactQueryBuilder();
        $queryBuilder->addUserRestriction();
        $queryBuilder->select($this->tablename . '.*');
        $queryBuilder->from($this->tablename);
        $queryBuilder->andWhere('(frontend_user IS NOT NULL AND frontend_user<>0)');
        $rows = $queryBuilder->executeQuery()
->fetchAllAssociative();
        return $this->dataMapper->map(Person::class, $rows);
    }
}
