<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Phonenumbers
 */
class PhonenumberRepository extends Repository
{
    public function findByPerson($person_uid)
    {
        $query = $this->createQuery();
        $query->matching($query->equals('pn_personid', $person_uid));
        //$query->setOrderings( array('ofCompanyname' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING));
        return $query->execute();
    }

    public function findByPersonAndCategory($person_uid, $cat_uid)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->equals('pn_personid', $person_uid),
                $query->equals('pn_phonecategoryid', $cat_uid)
            )
        );
        return $query->execute();
    }
}
