<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use Internetgalerie\IgDatapoolFe\DataHandling\DataHandler;
use Internetgalerie\IgsCrm\Domain\Model\TagField;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for TagField
 */
class TagFieldRepository extends Repository
{
    protected $tablename = 'tx_igscrm_domain_model_tagfield';
    protected $defaultOrderings = [
        'field_number' => QueryInterface::ORDER_ASCENDING,
        //'sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING
    ];

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findRawByUidAndLanguage(int $uid, int $languageUid)
    {
        $query = $this->createQuery();
        //$query->getQuerySettings()->setRespectSysLanguage(false);
        $query->getQuerySettings()
->setLanguageUid($languageUid);
        $query->matching($query->equals('l10n_parent', $uid));
        $res = $query->execute(true);

        return empty($res) ? $res : $res[0];
    }

    public function insertUpdateByUidAndLanguage(TagField $tagField, int $languageUid, array $data)
    {
        $uid = $tagField->getUid();
        $translated = $this->findRawByUidAndLanguage($uid, $languageUid);
        // create new translation
        if (empty($translated)) {
            $orig = $this->findRawByUidAndLanguage($uid, 0);
            $cmd['tx_igscrm_domain_model_tagfield'][$uid]['localize'] = $languageUid;
            $dataHandler = GeneralUtility::makeInstance(DataHandler::class);
            var_dump($uid, $languageUid);
            $dataHandler->localize('tx_igscrm_domain_model_tagfield', $uid, $languageUid);
        }
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        $queryBuilder->update($this->tablename)
                      ->where(
                          $queryBuilder->expr()
->eq('sys_language_uid', (int) $languageUid),
                          //$queryBuilder->expr()->eq('uid', (int) $data['uid']),
                          $queryBuilder->expr()
->eq('l10n_parent', (int) $uid),
                      );
        // update translated attributes
        foreach ($data as $attribute => $value) {
            if ($attribute == 'uid') {
                continue;
            }
            $queryBuilder->set($attribute, $value);
        }
        // Sync attributes
        $queryBuilder->set('field_number', $tagField->getFieldNumber());
        $queryBuilder->set('is_translated', $tagField->getIsTranslated());
        $queryBuilder->set('sorting', $tagField->getSorting());
        return $queryBuilder->executeStatement();
    }

    public function findRawByTagAndLanguage(int $uid, int $languageUid)
    {
        $query = $this->createQuery();
        //$query->getQuerySettings()->setRespectSysLanguage(false);
        $query->getQuerySettings()
->setLanguageUid($languageUid);
        $query->matching($query->equals('tag', $uid));
        $res = $query->execute(true);

        return $res;
    }
}
