<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Tag
 */
class TagRepository extends AbstractCrmRepository
{
    protected $defaultOrderings = [
        'name' => QueryInterface::ORDER_ASCENDING,
    ];

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findBySearch(array $search)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectStoragePage(false);
        $searchConstrains = [];
        $searchConstrains[] = $query->equals('verband', $search['verband'] ?? 0);
        if (isset($search['tagverband'])) {
            $searchConstrains[] = $query->equals('tagverband', (int) $search['tagverband']);
        }
        if (!empty($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }
        return $query->execute(true);
    }

    /*
 sql =  SELECT tag.uid AS tag_uid, tag.name AS tag_name,tagverband.name AS verband_name,tagverband.uid AS verband_uid FROM tx_igscrm_domain_model_tag AS tag JOIN tx_igscrm_domain_model_tagverband AS tagverband\
 ON tagverband.uid=tagverband WHERE tagverband.verband=###verbandUid### AND tag.deleted=0 AND tagverband.deleted=0 AND tag.hidden=0 AND  tagverband.hidden=0 ORDER BY verband_name,tag_uid,tag_name;
                groupBy = verband_name
                sqlWhere = EXISTS (SELECT 1 FROM tx_igscrm_contactverband_tag_mm WHERE uid_local=tx_igscrm_domain_model_contactverband.uid AND uid_foreign IN (###value###))
    */
}
