<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use Internetgalerie\IgDatapoolFe\DataHandling\DataHandler;
use Internetgalerie\IgsCrm\Domain\Model\TagRole;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
//use TYPO3\CMS\Core\DataHandling\DataHandler;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for TagRole
 */
class TagRoleRepository extends Repository
{
    protected $tablename = 'tx_igscrm_domain_model_tagrole';
    protected $defaultOrderings = [
        'sorting' => QueryInterface::ORDER_ASCENDING,
        'name' => QueryInterface::ORDER_ASCENDING,
    ];

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findRawByUidAndLanguage(int $uid, int $languageUid)
    {
        $query = $this->createQuery();
        //$query->getQuerySettings()->setRespectSysLanguage(false);
        $query->getQuerySettings()
->setLanguageUid($languageUid);
        $query->matching($query->logicalOr($query->equals('uid', $uid), $query->equals('l10n_parent', $uid)));
        $res = $query->execute(true);

        return empty($res) ? $res : $res[0];
    }

    public function insertUpdateByUidAndLanguage(TagRole $tagRole, int $languageUid, array $data)
    {
        $uid = $tagRole->getUid();
        $translated = $this->findRawByUidAndLanguage($uid, $languageUid);
        // create new translation
        if (empty($translated)) {
            $orig = $this->findRawByUidAndLanguage($uid, 0);
            $cmd['tx_igscrm_domain_model_tagrole'][$uid]['localize'] = $languageUid;
            $dataHandler = GeneralUtility::makeInstance(DataHandler::class);
            $dataHandler->localize('tx_igscrm_domain_model_tagrole', $uid, $languageUid);
            //$dataHandler->start($orig, $cmd);
            //$dataHandler->process_cmdmap();
        }
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        $queryBuilder->update($this->tablename)
                      ->where(
                          $queryBuilder->expr()
->eq('sys_language_uid', (int) $languageUid),
                          //$queryBuilder->expr()->eq('uid', (int) $data['uid']),
                          $queryBuilder->expr()
->eq('l10n_parent', (int) $uid),
                      );
        // update translated attributes
        foreach ($data as $attribute => $value) {
            if ($attribute == 'uid') {
                continue;
            }
            $queryBuilder->set($attribute, $value);
        }
        // Sync attributes
        $queryBuilder->set('sorting', $tagRole->getSorting());
        $queryBuilder->set('show_mail', $tagRole->getSorting());
        $affectedRows = $queryBuilder->executeStatement();
        return $affectedRows;
    }
    
    public function getMaxSortingByTag($tag)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        return $queryBuilder->selectLiteral('max(sorting)')
                     ->from($this->tablename)
                     ->where($queryBuilder->expr() ->eq('tag', $tag->getUid()))->executeQuery()
                     ->fetchOne();
    }
}
