<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Tagverband
 */
class TagverbandRepository extends Repository
{
    protected $defaultOrderings = [
        'name' => QueryInterface::ORDER_ASCENDING,
    ];
    public function findBySearch(array $search)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()
->setRespectStoragePage(false);
        $searchConstrains = [];
        $searchConstrains[] = $query->equals('verband', $search['verband'] ?? 0);
        if (!empty($searchConstrains)) {
            $query->matching($query->logicalAnd(...$searchConstrains));
        }
        return $query->execute(true);
    }
}
