<?php

namespace Internetgalerie\IgsCrm\EventListener;

use Ig\IgFibu\Event\SubtotalEvent;

final class SubtotalEventListener
{
    public function __invoke(SubtotalEvent $event): void
    {
        $invoice = $event->getInvoice();
        $totalTax = $event->getTotalTax();
        $taxRate = $invoice->getTaxRate();

        $subtotal = $invoice->getSubtotal();
        $subtotalExkl = $invoice->getSubtotalExkl();

        $sub1Inkl = $invoice->getSub1Inkl();
        $sub2Inkl = $invoice->getSub2Inkl();
        if ($sub1Inkl !== null) {
            $subtotal += $sub1Inkl;
            $tax = $sub1Inkl / (100 + $taxRate) * $taxRate;
            $subtotalExkl += $sub2Inkl - $tax;
            $totalTax += $tax;
        }
        if ($sub2Inkl !== null) {
            $subtotal += $sub2Inkl;
            $tax = $sub2Inkl / (100 + $taxRate) * $taxRate;
            $subtotalExkl += $sub2Inkl - $tax;
            $totalTax += $tax;
        }
        $invoice->setSubtotal($subtotal);
        $invoice->setSubtotalExkl($subtotalExkl);

        $event->setInvoice($invoice);
        $event->setTotalTax($totalTax);

        //var_dump($subtotal,$invoice->getSubtotalExkl(),$invoice);exit(0);
    }
}
