<?php

namespace Internetgalerie\IgsCrm\Utility;

use TYPO3\CMS\Core\SingletonInterface;

class ConfUtility implements SingletonInterface
{
    /**
     * flashMessageQueueIdentifier to share flashmessages between plugins
     *
     * @var string
     */
    public static $flashMessageQueueIdentifier = 'igCrm.queue';

    /**
     * Jahrgaenge definieren
     * f: ist anderes Alter bei Frauen verwenden (meAddressid=2)
     */
    protected $crmJahrgaenge = [
        1 => [
            'uid' => 1,
            'name' => 'Mitglieder unter 30 Jahren',
            'min' => 0, // greater than or equals
            'max' => 30, // less than
        ],
        2 => [
            'uid' => 2,
            'name' => 'Mitglieder 30 und kleiner AHV-Alter',
            'min' => 30,
            // greater than or equals
            'max' => 66,
            // less than
            'f' => [
                'min' => 30,
                'max' => 65,
            ],
        ],
        3 => [
            'uid' => 3,
            'name' => 'Mitglieder über AHV-Alter',
            'min' => 66,
            // greater than or equals
            'max' => 200,
            // less than
            'f' => [
                'min' => 65,
                'max' => 200,
            ],
        ],
        4 => [
            'uid' => 4,
            'name' => 'AHV-Alter',
            'min' => 66,
            // greater than or equals
            'max' => 66,
            // less than
            'f' => [
                'min' => 65,
                'max' => 65,
            ],
        ],
    ];
    protected $crmVertorbene = [
        'Contact' => [
            '0' => 'Keine Verstorbene/Aufgelöste',
            '1' => 'nur Verstrobene/Aufgelöste',
        ],
        'Person' => [
            '0' => 'Keine Verstorbene',
            '1' => 'nur Verstrobene',
        ],
        'Organisation' => [
            '0' => 'Keine aufgelösten',
            '1' => 'nur aufgelöste',
        ],
    ];


    public function getCrmJahrgaenge()
    {
        return $this->crmJahrgaenge;
    }
    public function getCrmVertorbene($type)
    {
        return $this->crmVertorbene[$type] ?? $this->crmVertorbene['Contact'];
    }
}
