<?php

namespace Internetgalerie\IgsCrm\Utility;

use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;

class ExportUtility
{
    /**
     * organisationRepository
     *
     * @var OrganisationRepository
     */
    protected $organisationRepository = null;

    /**
     * personRepository
     *
     * @var PersonRepository
     */
    protected $personRepository = null;

    public function injectOrganisationRepository(OrganisationRepository $organisationRepository): void
    {
        $this->organisationRepository = $organisationRepository;
    }

    public function injectPersonRepository(PersonRepository $personRepository): void
    {
        $this->personRepository = $personRepository;
    }

    public function value($val, $length = null)
    {
        $val = str_replace('  ', ' ', str_replace(',', ' ', $val));
        return $length > 0 ? mb_substr($val, 0, $length) : $val;
    }
   
  
    public function getAddressHeader($name)
    {
        $lower = strtolower((string) $name);
        return [
            $lower . 'Organisation.ofCompanyname' => $name . ' Invoicesadresse Firma',
            $lower . 'Organisation.ofAddon' => $name . ' Invoicesadresse Line1',
            $lower . 'Organisation.ofStreet' => $name . ' Invoicesadresse Line2',
            $lower . 'Organisation.ofPobox' => $name . ' Invoicesadresse Postfach',
            $lower . 'Organisation.ofZip' => $name . ' Invoicesadresse PLZ',
            $lower . 'Organisation.ofCity' => $name . ' Invoicesadresse Ort',
        ];
    }
    public function getAddressHeaderValues($name)
    {
        if ($name == 'IGS') {
            $extraFelder = [$name . ' Invoices ID'];
        } else {
            $extraFelder = [$name . ' Invoicesadresse', $name . ' Invoices ID'];
        }
        return array_merge($extraFelder, array_values($this->getAddressHeader($name)));
    }

    
    public function getAddressValues($organisation, $name)
    {
        $organisationId = $organisation ? (int) $organisation->getUid() : null;
        $ret = [];
        $addressTyp = '';
        if ($organisationId) {
            $organisation = $this->organisationRepository->rawByUid($organisationId);
            $extraFelder = ['Büroadresse'];
            $ret = [
                $organisationId,
                $organisation['of_companyname'],
                $organisation['of_addon'],
                $organisation['of_street'],
                $organisation['of_pobox'],
                $organisation['of_zip'],
                $organisation['of_city'],
            ];
        } else {
            $extraFelder = ['Privat'];
            $ret = [
                $organisationId,
                '', // of_companyname
                '', // of_addon
                '', // of_street
                '', // of_pobox
                '', // of_zip
                '', // of_city
            ];
        }
      
        if ($name == 'IGS') {
            return $ret;
        }
        return array_merge($extraFelder, $ret);
    }
  
    public function personAddAddress(&$person, $attributeName, $organisationId): void
    {
        if ($organisationId) {
            $organisation = $this->organisationRepository->rawByUid($organisationId);
            $person[$attributeName . 'Organisation.ofCompanyname'] = $organisation['of_companyname'];
            $person[$attributeName . 'Organisation.ofAddon'] = $organisation['of_addon'];
            $person[$attributeName . 'Organisation.ofStreet'] = $organisation['of_street'];
            $person[$attributeName . 'Organisation.ofPobox'] = $organisation['of_pobox'];
            $person[$attributeName . 'Organisation.ofZip'] = $organisation['of_zip'];
            $person[$attributeName . 'Organisation.ofCity'] = $organisation['of_city'];
        } else {
            $person[$attributeName . 'Organisation.ofCompanyname'] = '';
            $person[$attributeName . 'Organisation.ofAddon'] = '';
            $person[$attributeName . 'Organisation.ofStreet'] = '';
            $person[$attributeName . 'Organisation.ofPobox'] = '';
            $person[$attributeName . 'Organisation.ofZip'] = '';
            $person[$attributeName . 'Organisation.ofCity'] = '';
        }
    }
    public function personsExpandAddresses(&$fields, &$persons): void
    {
        $igs = isset($fields['me_igs_invoice_id']);
        $geosuisse = isset($fields['me_geosuisse_invoice_id']);
        $sgpf = isset($fields['me_sgpf_invoice_id']);
        if ($igs) {
            $fields = array_merge($fields, $this->getAddressHeader('IGS'));
        }
        if ($geosuisse) {
            $fields = array_merge($fields, $this->getAddressHeader('geosuisse'));
        }
        if ($sgpf) {
            $fields = array_merge($fields, $this->getAddressHeader('SGPF'));
        }
    
        foreach ($persons as &$person) {
            if ($igs) {
                $this->personAddAddress($person, 'igs', $person['me_igs_invoice_id']);
            }
            if ($geosuisse) {
                $this->personAddAddress($person, 'geosuisse', $person['me_geosuisse_invoice_id']);
            }
            if ($sgpf) {
                $this->personAddAddress($person, 'sgpf', $person['me_sgpf_invoice_id']);
            }
        }
    }
}
