<?php

namespace Internetgalerie\IgsCrm\Utility;
use TYPO3\CMS\Core\Database\Connection;

use PDO;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class ImportUtility
{
    protected $debug = false;

    protected $fp = null;
    protected $importConfig = null;
    protected $config = null;
    protected $mainTable = null;
    protected $relations = [];
    protected $insertCount = 0;
    protected $updateCount = 0;

    public function open($filename, $importConfig = null): void
    {
        $this->importConfig = $importConfig;
        if (($this->fp = fopen($filename, 'r')) === false) {
            die('<h1>File is missing</h1>');
        }
        if ($importConfig === null) {
            return;
        }
        for ($i = 0;$i < $this->importConfig->getIgnoreLinesAtBegining() + ($this->importConfig->getHasHeaderLine() ? 1 : 0);$i++) {
            fgetcsv($this->fp);
        }
        /*
        $this->config=$this->importConfig->getConfig();
        $this->mainTable=$this->config['mainTable'];
        $this->relations=$this->config['relations'];
        */
        $this->insert = 0;
        $this->update = 0;
    }
    public function close()
    {
        return fclose($this->fp);
    }
  
    public function getLine()
    {
        if (($data = fgetcsv($this->fp)) === false) {
            return false;
        }
        $row = [];
        //$table=$this->importConfig->getTablename();
        foreach ($this->importConfig->getCols() as $nr => $col) {
            if ($col['attribute']) {
                $table = $col['table'] ?: $this->importConfig->getTablename();
                if (!isset($row[$table])) {
                    $row[$table] = [];
                }
                $val = $data[$nr];
                if (isset($col['default']) && $col['default'] !== '' && ($val === null || $val === '')) {
                    $val = $col['default'];
                }
                $func = $col['filter'];
                if ($func) {
                    $val = $this->{$func}($val);
                    /*
                      if($func=='getDate') {
                      die($table .'.'. $col['attribute'] .'='.$val);
                      }*/
                }

                $row[$table][$col['attribute']] = $val;
            }
        }
        return $row;
    }

    public function insertMainData($row)
    {
        $this->insertCount++;
        if ($this->debug) {
            echo 'INSERT: ' . $this->mainTable['table'] . '<br />';
        }
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            $this->mainTable['table']
        );
        // @todo fix/static
        $values = array_merge($this->mainTable['insertDefaultValues'], $row[$this->mainTable['table']]);
        $affectedRows = $queryBuilder->insert($this->mainTable['table'])->values($values)->executeStatement();
        $conn = $queryBuilder->getConnection();//GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->mainTable['table']);
        $lastInsertId = $conn->lastInsertId();
        if ($this->debug) {
            echo 'lastInsertId=' . $lastInsertId . '<br />';
        }
        if ($this->debug) {
            var_dump($row[$this->mainTable['table']]);
        }
        return $lastInsertId;//$db->->lastInsertId();
    }
    public function insertData($row): void
    {
        $uid = $this->insertMainData($row);
        foreach ($this->relations as $relation) {
            if ($this->debug) {
                echo 'INSERT: ' . $relation['table'] . '<br />';
            }
            if ($row[$relation['table']]['active']) {
                $row[$relation['table']][$relation['field']] = $uid;
                $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                    $relation['table']
                );
                $values = array_merge($relation['insertDefaultValues'], $row[$relation['table']]);
                $affectedRows = $queryBuilder->insert($relation['table'])->values($values)->executeStatement();
                if ($this->debug) {
                    var_dump($row[$relation['table']]);
                }
            }
        }
    }
    public function updateData($row, $uid): void
    {
        $this->updateCount++;
        if ($this->debug) {
            echo 'UPDATE: ' . $this->mainTable['table'] . '<br />';
        }
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            $this->mainTable['table']
        );
        $values = array_merge($this->mainTable['updateDefaultValues'], $row[$this->mainTable['table']]);
        $queryBuilder->update($this->mainTable['table'])->where(
            $queryBuilder->expr()
->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT))
        );
        foreach ($values as $name => $value) {
            $queryBuilder->set($name, $value);
        }
        $queryBuilder->executeStatement();
        $lastInsertId = $uid;
        if ($this->debug) {
            var_dump($row[$this->mainTable['table']]);
        }
        foreach ($this->relations as $relation) {
            if ($this->debug) {
                echo 'UPDATE: ' . $relation['table'] . '<br />';
            }
            if ($row[$relation['table']]['active']) {
                $row[$relation['table']][$relation['field']] = $uid;
                //$row[$relation['table']][$relation['field']]=$uid;
                // @todo static
                $values = array_merge($relation['updateDefaultValues'], $row[$relation['table']]);
                // @todo testen ob existiert sonst insert
                $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                    $relation['table']
                );
    
                $queryBuilder->update($relation['table'])->where(
                    $queryBuilder->expr()
->eq('person', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT))
                );
                foreach ($values as $name => $value) {
                    $queryBuilder->set($name, $value);
                }
                $queryBuilder->executeStatement();
                if ($this->debug) {
                    var_dump($row[$relation['table']]);
                }
            }
        }
    }

    


    public function getInsertCount()
    {
        return $this->insertCount;
    }
    public function getUpdateCount()
    {
        return $this->updateCount;
    }







    public function getAnrede($value)
    {
        if ($value == 'Herr') {
            return 1;
        }
        if ($value == 'Frau') {
            return 2;
        }
        if ($value == 'Firma') {
            return 3;
        }
    }

    public function getBoolean($value)
    {
        $letter = strtolower(substr(trim((string) $value), 0, 1));
        if (intval($value) > 0 || $letter == 'j' || $letter == 'y' || $letter == 'x') {
            return 1;
        }
        return 0;
    }

    public function getLanguage($value)
    {
        $value = substr(trim((string) $value), 0, 1);
        if ($value == 'F' || $value == 'f') { //'Französisch'
            return 3;
        }
        if ($value == 'E' || $value == 'e') { //'Englisch'
            return 2;
        }
        if ($value == 'I' || $value == 'i') { //'Italienisch'
            return 4;
        }
        return 1;
    }

    public function getInt($value)
    {
        return intval(str_replace("'", '', $value));
    }
    public function getDate($value)
    {
        if (strpos((string) $value, '.')) {
            $parts = explode('.', (string) $value);
            $y = intval(trim($parts[2]));
            $m = intval(trim($parts[1]));
            $d = intval(trim($parts[0]));
            if ($y < 100) {
                $y += 1900;
            }
            return $y . '-' . str_pad($m, 2, '0', STR_PAD_LEFT) . '-' . str_pad($d, 2, '0', STR_PAD_LEFT);
        }
        return $value;
    }

    // IN unterklasse
    public function getKanton($value)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_kanton'
        );
        $queryBuilder->select('uid')
      ->from('tx_igscrm_domain_model_kanton')
      ->where($queryBuilder->expr() ->eq('ka_abkuerzung', $queryBuilder->createNamedParameter($value)));
        $result = $queryBuilder->executeQuery();
        if ($row = $result->fetchAssociative()) {
            return $row['uid'];
        }
        return null;
    }
}
