<?php

namespace Internetgalerie\IgsCrm\Utility;

use Internetgalerie\IgAcl\Domain\Model\AclOwnerInterface;
use Internetgalerie\IgAcl\Utility\AclUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
//use Internetgalerie\IgsCrm\Domain\Model\AclOwnerInterface;
use Internetgalerie\IgsCrm\Domain\Model\FrontendUser;
use Internetgalerie\IgsCrm\Domain\Repository\ContactContactRepository;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository;
use Internetgalerie\IgsCrm\Domain\Repository\FrontendUserRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class SecurityUtility extends AclUtility implements SingletonInterface
{

    /**
     * @var VerbandRepository
     */
    protected $verbandRepository = null;


    //protected ?FrontendUser $frontendUser = null;
    protected ?Contact $contact = null;
    //protected static ?ConfigurationManagerInterface $configurationManager = null;
    protected static ?array $crmSettings = null;
    //private $feAdminUid = 21; // 2 bei panoramarundweg

    //private static $frontendUserGroupIds = null;
    private static $frontendUserVerbandIds = null;
    private static $frontendUserVerbands = null;


    
    // public function __construct(
        
    //     protected FrontendUserRepository $frontendUserRepository,
    // )
    // {
    //     $this->context = GeneralUtility::makeInstance(Context::class);
    //     $settings = self::getSettings();
    //     $this->feAdminUid = (int) $settings['feAdminUid'] ?? $this->feAdminUid;

    // }
    
    // public function isAdmin()
    // {
    //     $frontendUserGroupIds = $this->getFrontendUserGroupIds();
    //     return in_array($this->feAdminUid, $frontendUserGroupIds);
    // }
    // public function getFeAdminUId()
    // {
    //     return $this->feAdminUid;
    // }


    public function getFrontendUser()
    {
        if ($this->frontendUser === null) {
            $this->frontendUserRepository->setRespectStoragePage(false);
            $frontendUserId = $this->getFrontendUserId();
            if ($frontendUserId > 0) {
                $this->frontendUser = $this->frontendUserRepository->findOneBy([
                    'uid' => $frontendUserId,
                ]);
            }
        }
        return $this->frontendUser;
    }

    
    /**
     * checks if user has write access to $object
     *
     * @param AclOwnerInterface $object The modified object
     * @return bool has access
     */
    // public function aclHasWrite(AclOwnerInterface $object = null)
    // {
    //     if ($this->isAdmin()) {
    //         return true;
    //     }
    //     // grant access to new objects
    //     if ($object === null) {
    //         return true;
    //     }
    //     if ($object->getAclOwner() == $this->getFrontendUserId()) {
    //         return true;
    //     }
    //     $frontendUserGroupIds = $this->getFrontendUserGroupIds();
    //     foreach ($object->getAclWriteGroups() as $group) {
    //         if (in_array($group->getUid(), $frontendUserGroupIds)) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }
    /**
     * checks if user has read access to $object
     *
     * @param AclOwnerInterface $object The modified object
     * @return bool has access
     */
    // public function aclHasRead(AclOwnerInterface $object)
    // {
    //     if ($this->isAdmin()) {
    //         return true;
    //     }
    //     // read check for empty objects are errors
    //     if ($object === null) {
    //         return false;
    //     }
    //     if ($object->getAclOwner() == $this->getFrontendUserId()) {
    //         return true;
    //     }
    //     $frontendUserGroupIds = $this->getFrontendUserGroupIds();
    //     foreach ($object->getAclReadGroups() as $group) {
    //         if (in_array($group->getUid(), $frontendUserGroupIds)) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }
    
    // public function aclCanWrite(AclOwnerInterface $object = null, array $additionalGroups = [])
    // {
    //     // check if user has groups
    //     if (!empty($additionalGroups)) {
    //         foreach ($additionalGroups as $additionalGroup) {
    //             if (!$this->hasGroupName($additionalGroup)) {
    //                 return false;
    //             }
    //         }
    //     }
    //     // acl check of entry
    //     if ($this->aclHasWrite($object)) {
    //         return true;
    //     }
    //     $uids = $this->getFrontendUserOwnerUids(1);
    //     if (!empty($uids) && in_array($object->getUid(), $uids)) {
    //         //var_dump($uids,get_class($object), $object->getType());exit(0);
    //         return true;
    //     }
    //     return false;
    // }

    // public function aclCanRead(AclOwnerInterface $object = null, array $additionalGroups = [])
    // {
    //     // check if user has groups
    //     if (!empty($additionalGroups)) {
    //         foreach ($additionalGroups as $additionalGroup) {
    //             if (!$this->hasGroupName($additionalGroup)) {
    //                 return false;
    //             }
    //         }
    //     }
    //     // acl check of entry, group is in acl read list
    //     if ($this->aclHasRead($object)) {
    //         return true;
    //     }
    //     $uids = $this->getFrontendUserOwnerUids(0);
    //     if (!empty($uids) && in_array($object->getUid(), $uids)) {
    //         //var_dump($uids,get_class($object), $object->getType());exit(0);
    //         return true;
    //     }
    //     return false;
    // }

    public function setAcl(AclOwnerInterface &$object, int $verbandUid = null): void
    {
        if ($object->getUid() > 0) {
            // update
            if ($verbandUid > 0) {
                die('update in setAcl SecurityUtility with verbandUid. Bug?');
            }
        } else {
            //new
            $object->setAclOwner($this->getFrontendUserId());

            if ($verbandUid > 0) {
                $verbandRepository = $this->getVerbandRepository();
                $verband = $verbandRepository->findByUid($verbandUid);
                if ($verband) {
                    $objectStorage = GeneralUtility::makeInstance(ObjectStorage::class);
                    foreach ($verband->getAclReadGroups() as $group) {
                        $objectStorage->attach($group);
                    }
                    $object->setAclReadGroups($objectStorage);

                    $objectStorage = GeneralUtility::makeInstance(ObjectStorage::class);
                    foreach ($verband->getAclWriteGroups() as $group) {
                        $objectStorage->attach($group);
                    }
                    $object->setAclWriteGroups($objectStorage);
                }
            } else {
                if ($this->getFrontendUserCrmDefaultGroupId()) {
                    $crmDefaultGroup = $this->getFrontendUserCrmDefaultGroup();
                    $objectStorage = GeneralUtility::makeInstance(ObjectStorage::class);
                    $objectStorage->attach($crmDefaultGroup);
                    $object->setAclReadGroups($objectStorage);
                    $objectStorage = GeneralUtility::makeInstance(ObjectStorage::class);
                    $objectStorage->attach($crmDefaultGroup);
                    $object->setAclWriteGroups($objectStorage);
                }
            }
        }
        /*
        $verbands = $this->getFrontendUserVerbands();
        $verband = null;
        // user has 1 verband, take this
        if (count($verbands) == 1) {
            foreach($verbands as  $v) {
                $verband = $v;
            }
        }
        // check if user gas access to given verband
                foreach($verbands as  $v) {
                    if ($verbandUid === $v->getUid()) {
                        $verband = $v;
                        break;
                    }
                }
        */
    }

    

    public function getFrontendUserContact()
    {
        if ($this->contact === null) {
            $this->getFrontendUser();
            if ($this->frontendUser instanceof FrontendUser) {
                $this->contact = $this->frontendUser->getContact();
            }
        }
        return $this->contact;
    }
    
    public function getFrontendUserVerbandIds()
    {
        if (static::$frontendUserVerbandIds === null) {
            static::$frontendUserVerbandIds = [];
            $verbandRepository = GeneralUtility::makeInstance(VerbandRepository::class);
            $verbands = $verbandRepository->findAllWithAcl(true);
            foreach ($verbands as $verband) {
                if ($verband['uid'] > 0) {
                    static::$frontendUserVerbandIds[] = $verband['uid'];
                }
            }
        }
        return static::$frontendUserVerbandIds;
    }

    public function getFrontendUserVerbands()
    {
        if (static::$frontendUserVerbands === null) {
            static::$frontendUserVerbands = [];
            $verbandRepository = GeneralUtility::makeInstance(VerbandRepository::class);
            static::$frontendUserVerbands = $verbandRepository->findAllWithAcl();
        }
        return static::$frontendUserVerbands;
    }

    public function getFrontendUserCrmDefaultGroupId()
    {
        return FrontendUserRepository::getCurrentFrontendUserRaw()['crm_default_group'] ?? 0;
    }
    /**
     * @return  crm default group or null if none is set / or group not exists
     */

    public function getFrontendUserCrmDefaultGroup()
    {
        $crmDefaultGroupId = $this->getFrontendUserCrmDefaultGroupId();
        if ($crmDefaultGroupId > 0) {
            $frontendUserGroupRepository = GeneralUtility::makeInstance(FrontendUserGroupRepository::class);
            $frontendUserGroupRepository->setRespectStoragePage(false);
            $crmDefaultGroup = $frontendUserGroupRepository->findOneBy([
                'uid' => $crmDefaultGroupId,
            ]);
            return $crmDefaultGroup;
        }
        return null;
    }

    // public function getFrontendUserGroupNames()
    // {
    //     return $this->context->getPropertyFromAspect('frontend.user', 'groupNames');
    // }
    // public function hasGroupName(string $groupName)
    // {
    //     $groupNames = $this->context->getPropertyFromAspect('frontend.user', 'groupNames');
    //     return in_array($groupName, $groupNames);
    // }
    public function getGlobal()
    {
        if (isset($_COOKIE['global'])) {
            return json_decode((string) $_COOKIE['global'], true);
        }
        return [];
    }
    public function getGlobalVerband()
    {
        $global = $this->getGlobal();
        return (int)($global['verband'] ?? 0);
    }

    public function getFrontendUserHeaderVerband(int $globalVerbandUid = null)
    {
        $headerVerbands = [];
        $frontendUserAuthentication = $this->getRequest()->getAttribute('frontend.user');

        
        if (!empty($frontendUserAuthentication->user['crm_verband_uids'])) {
            $verbandRepository = $this->getVerbandRepository();
            $crmVerbandUids = GeneralUtility::intExplode(
                ',',
                $frontendUserAuthentication->user['crm_verband_uids'],
                true
            );
            if ($globalVerbandUid === null || $globalVerbandUid === 0 || in_array($globalVerbandUid, $crmVerbandUids)) {
                $headerVerbands = $verbandRepository->findWithUids($crmVerbandUids);
            }
        }
        return $headerVerbands;
    }
    public function getVerbandRepository()
    {
        if ($this->verbandRepository === null) {
            $this->verbandRepository = GeneralUtility::makeInstance(VerbandRepository::class);
        }
        return $this->verbandRepository;
    }

    public static function generateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
        
    public static function checkPassword($password)
    {
        $minPasswordLength = 6;
        if (strlen((string) $password) < $minPasswordLength) {
            return 'Das Password muss mindestes ' . $minPasswordLength . ' Zeichen lang sein.';
        }
        return null;
    }
    public function getFeUserTagUids()
    {
        $frontendUserAuthentication = $this->getRequest()->getAttribute('frontend.user');
        return GeneralUtility::intExplode(',', $frontendUserAuthentication->user['company'], true);
    }
    public function getFeUserTags()
    {
        $feUserTagUids = $this->getFeUserTagUids();
        $feUserTags = [];
        $tagRepository = GeneralUtility::makeInstance(TagRepository::class);
        if (!empty($feUserTagUids)) {
            foreach ($feUserTagUids as $tagId) {
                $feUserTag = $tagRepository->findByUid($tagId);
                $feUserTags[] = $feUserTag;
            }
        }
        return $feUserTags;
    }
    public function getFeUserTagsGrouped()
    {
        $feUserTags = [];
        foreach ($this->getFeUserTags() as $feUserTag) {
            $tagverbandUid = $feUserTag->getTagverband()
->getUid();
            if (!isset($feUserTags[$tagverbandUid])) {
                $feUserTags[$tagverbandUid] = [
                    'tagverband' => $feUserTag->getTagverband(),
                    'items' => [],
                ];
            }
            $feUserTags[$tagverbandUid]['items'][] = $feUserTag;
        }
        return $feUserTags;
    }

    // public function getFrontendUserOwnerUids($acl = 0)
    // {
    //     $contactUids = [];
    //     $frontendUserId = $this->getFrontendUserId();
    //     if ($frontendUserId > 0) {
    //         $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
    //         $contacts = $personRepository->findByFrontendUser($this->getFrontendUserId(), true);
    //         if (!empty($contacts)) {
    //             foreach ($contacts as $contact) {
    //                 $contactUids[] = (int) $contact ['uid'];
    //             }
    //             //$ret['Person'] = $contactUids;
    //         }
    //     }
    //     if (!empty($contactUids)) {
    //         $contactContactRepository = GeneralUtility::makeInstance(ContactContactRepository::class);
    //         $relations = $contactContactRepository->findRelationByContact($contactUids, true);
    //         if (!empty($relations)) {
    //             foreach ($relations as $relation) {
    //                 if ($relation['acl'] >= $acl) {
    //                     $contactUids[] = (int) $relation ['organisation'];
    //                 }
    //             }
    //         }
    //     }
    //     return $contactUids;
    // }
    public static function getUidYearHash(int $uid, int $year, $maxLength = 24): string
    {
        $crmSettings = self::getCrmSettings();
        $secret = $crmSettings['secret'];
        if ($secret === '') {
            die('no secret defined in typoscript');
        }
        $data = $uid . ':' . $year . ':' . $secret;
        $hash = hash('sha256', $data, true);
        $base64Hash = base64_encode($hash);
        return $uid . '_' . substr($base64Hash, 0, $maxLength);
    }

    protected static function getConfigurationManager(): ConfigurationManagerInterface
    {
        if (static::$configurationManager !== null) {
            return static::$configurationManager;
        }
        static::$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        return static::$configurationManager;
    }
 
    protected static function getCrmSettings(): array
    {
        if (static::$crmSettings === null) {
            $all = static::getConfigurationManager()->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            );
            static::$crmSettings = $all['plugin.']['tx_igcrmadmin.']['settings.'] ?? [];
        }
        return static::$crmSettings;
    }

    // @todo set Request on creation
    protected function getRequest()
    {
        return $GLOBALS['TYPO3_REQUEST'];
    }

}
