<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Contact;

use Internetgalerie\IgCrmAdmin\Utility\ContactUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

class LinkViewHelper extends AbstractTagBasedViewHelper
{
    public static $configurationManager = null;
    /**
     * @var string
     */
    protected $tagName = 'a';

    
    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerUniversalTagAttributes();
        $this->registerArgument('contact', Contact::class, 'contact object', false);
        $this->registerArgument('uid', 'int', 'uid of contact object', false);
        $this->registerArgument('type', 'string', 'type of contact object', false);
        $this->registerArgument('verband', Verband::class, 'verband object', false, null);
        $this->registerArgument('verbandUid', 'int', 'uid of verband object', false, null);
        //$this->registerArgument('uid', 'int', 'contact uid', true);
    }
    /**
     * @return string
     */
    public function render()
    {
        $contact = $this->arguments['contact'] ?? null;
        $contactUid = $this->arguments['uid'] ?? null;
        $contactType = $this->arguments['type'] ?? null;
        $verband = $this->arguments['verband'] ?? null;
        $verbandUid = $this->arguments['verbandUid'] ?? null;

        if ($verbandUid === null) {
            $verbandUid = $verband instanceof Verband ? $this->arguments['verband']->getUid() : null;
        }
        
        $settings = static::getConfigurationManager()
             ->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS, 'IgCrmAdmin', '');
        if ($contact instanceof Contact) {
            $uri = ContactUtility::getShowUri($this->renderingContext->getRequest(), $contact, $settings, $verbandUid);
        } else {
            $uri = ContactUtility::getShowUriByUidType(
                $this->renderingContext->getRequest(),
                $contactUid,
                $contactType,
                $settings,
                $verbandUid
            );
        }
        $this->tag->addAttribute('href', $uri);
        $this->tag->setContent($this->renderChildren());
        $this->tag->forceClosingTag(true);
        return $this->tag->render();
    }

    /**
     * Returns instance of the configuration manager
     *
     * @return ConfigurationManagerInterface
     */
    protected static function getConfigurationManager()
    {
        if (static::$configurationManager !== null) {
            return static::$configurationManager;
        }
        static::$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        return static::$configurationManager;
    }
}
