<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Contact;

use Closure;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\Tag;
use Internetgalerie\IgsCrm\Domain\Repository\ContactTagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRoleRepository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

//use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithContentArgumentAndRenderStatic;

class RoleViewHelper extends AbstractViewHelper
{
    public static $cacheTagRoles = null;

    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    //\TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper {

    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('contact', Contact::class, 'Contact: Person/Organisation', true);
        $this->registerArgument('tag', Tag::class, 'Tag', true);
        $this->registerArgument('as', 'string', 'contactTag', false, 'contactTag');
    }
    
    public function render(): string
    {
        $contact = $this->arguments['contact'];
        $tag = $this->arguments['tag'];
        //$templateVariableContainer=$this->renderingContext->getVariableProvider();
        //$this->tagRepository->findByUid($searchTag);
        if (self::$cacheTagRoles === null) {
            $tagRoleRepository = GeneralUtility::makeInstance(TagRoleRepository::class);
            $tagRoles = $tagRoleRepository->findBy([
                'tag' => $tag,
            ]);
            self::$cacheTagRoles = [];
            if ($tagRoles->count()) {
                foreach ($tagRoles as $tagRole) {
                    self::$cacheTagRoles[] = $tagRole->getUid();
                }
            }
        }
        $contactTagRepository = GeneralUtility::makeInstance(ContactTagRepository::class);
        $contactTag = $contactTagRepository->findOneByContactTags($contact, self::$cacheTagRoles);
        /*
        if ($person->getUId() ==435) {
            var_dump(self::$cacheTagRoles,$contactTag->getUid(), $contactTag->getTagRole()->getName());exit(0);
        }
        */
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $contactTag);
        $output =  $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
        //. '::as=' . $this->arguments['as'] .'('.$person->getUid(). ','. $verband->getUid().'='.( $contactVerband ? $contactVerband->getVerband()->getUid() : '').')';
    }
}
