<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Contact;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'contact uid', true);
        $this->registerArgument('as', 'string', 'name for contact object ', true);
    }

    public function render(): string
    {
        $contactRepository = GeneralUtility::makeInstance(ContactRepository::class);
        $contactUid = $this->arguments['uid'];
        $contact = $contactRepository->findByUid($contactUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $contact);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
