<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Contact;

use Closure;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

//use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithContentArgumentAndRenderStatic;

class VerbandViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    //\TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper {

    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('contact', Contact::class, 'Contact: Person/Organisation', true);
        $this->registerArgument('verband', Verband::class, 'Verband', true);
        $this->registerArgument('as', 'string', 'contactVerband', false, 'contactVerband');
    }

    public function render(): string
    {
        $contact = $this->arguments['contact'];
        $verband = $this->arguments['verband'];
        //$templateVariableContainer=$this->renderingContext->getVariableProvider();
        $contactVerband = $contact->getContactVerbandById($verband->getUid());
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $contactVerband);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
