<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Format;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TimeViewHelper extends AbstractViewHelper
{
    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        //$this->registerArgument('value', 'string', 'source', true);
        $this->registerArgument('time', 'int', 'Zeit in Sekunden', false);
    }

    public function render(): string
    {
        if (isset($this->arguments['time'])) {
            $time = (int)$this->arguments['time'];
        } else {
            $time = (int) $this->renderChildren();
        }
        $s = $time % 60;
        $timeM = ($time - $s) / 60;
        $m = $timeM % 60;
        $h = ($timeM - $m) / 60;

        return sprintf('%d:%02d:%02d', $h, $m, $s);
    }
}
