<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\FrontendUser;

use Closure;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class UsernameViewHelper extends AbstractViewHelper
{
    protected static $cache = [];
    
    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('uid', 'int', 'frontendUser uid', true);
    }

    public function render(): string
    {
        $uid = $this->arguments['uid'];
        if (!isset(static::$cache[$uid])) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
            $result = $queryBuilder->select('username')
                    ->from('fe_users')
                    ->where('uid=' . (int) $uid)
                    ->executeQuery();
            static::$cache[$uid] = $result->fetchOne();
        }
        return static::$cache[$uid];
    }
}
