<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Hash;

use Closure;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class UidYearViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'contact uid', true);
        $this->registerArgument('year', 'int', 'year', true);
        $this->registerArgument('as', 'string', 'name for contact object ', true);
    }
    
    public function render(): string
    {
        $uid = (int)$this->arguments['uid'];
        $year = (int)$this->arguments['year'];
        
        $validationHash = SecurityUtility::getUidYearHash($uid, $year);
        
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $validationHash);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
