<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Language;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    protected static $languages = null;

    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'language uid', true);
        $this->registerArgument('as', 'string', 'name for language object ', true);
    }

    public function render(): string
    {
        $languageUid = $this->arguments['uid'];
        if (static::$languages === null) {
            static::$languages = [];
            $languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
            foreach ($languageRepository->findAll() as $language) {
                static::$languages[$language->getUid()] = $language;
            }
        }
        
        $language = static::$languages[$languageUid] ?? null;
        if ($language === null) {
            return '';
        }
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $language);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
