<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Link;

use Closure;
use Internetgalerie\IgsCrm\Domain\Model\Tag;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class SearchViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    public function initializeArguments(): void
    {
        $this->registerArgument('as', 'string', 'The name of the iteration variable', true, 'search');
        $this->registerArgument('varband', 'int', 'tag', false);
        $this->registerArgument('tag', Tag::class, 'tag', false);
        $this->registerArgument('arguments', 'array', 'array', false, []);
    }

    public function render(): string
    {
        $tag = $this->arguments['tag'] ?? null;
        if ($tag === null) {
            return '';
        }
        $search = array_merge($this->arguments['arguments'], [
            'tags' => [
                $tag->getTagverband()
->getUid() => $tag,
            ],
        ]);
        //var_dump($this->arguments['as'],$search);exit(0);
         
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $search);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
