<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Membership;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    protected static $memberships = [];
    
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'membership uid', true);
        $this->registerArgument('as', 'string', 'name for membership object ', true);
    }
    
    public function render(): string
    {
        $membershipUid = $this->arguments['uid'];
        if (!isset(static::$memberships[$membershipUid])) {
            $membershipRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
            $membership = $membershipRepository->findByUid($membershipUid);
            static::$memberships[$membershipUid] = $membership;
        } else {
            $membership = static::$memberships[$membershipUid];
        }
        
        if ($membership === null) {
            return '';
        }
        $templateVariableContainer =  $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $membership);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
