<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Organisation;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class CategoryExistsViewHelper extends AbstractViewHelper
{
    // falls HTML Tages erlaubt sind
    protected $escapeOutput = false;
    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('organisation', 'object', 'Organisation', true);
        $this->registerArgument('category', 'object', 'categoryOrganisation', true);
        $this->registerArgument('as', 'string', 'Objeket ist zugänglich unter diesem Namen', false, 'cat');
    }

    public function render(): string
    {
        $organisation = $this->arguments['organisation'];
        return $organisation->hasCategoryOrganisation(
            $this->arguments['category']->getUid()
        ) ? $this->renderChildren() : '';
    }
}
