<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Organisation;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class FilialenAsTextViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'organisation uid', true);
        $this->registerArgument('verband', 'int', 'verband uid', true);
        $this->registerArgument('as', 'string', 'name for organisation object ', true);
    }
    
    public function render(): string
    {
        $organisationRepository = GeneralUtility::makeInstance(OrganisationRepository::class);
        $organisationUid = $this->arguments['uid'];
        $verbandUid = $this->arguments['verband'];
        $organisations = $organisationRepository->findRawFilialenActive($organisationUid, $verbandUid);
        $filialen = '';
        //$meficcFilialen = $this->getFilialen();
        foreach ($organisations as $f) {
            if ($filialen) {
                $filialen .= ', ';
            }
            $filialen .= $f['me_companyname'] . ' ' . $f['me_zip'] . ' ' . $f['me_city'];
            //$filialen .= $f->getMeCompanyname() . ' ' . $f->getMeZip() . ' ' . $f->getMeCity();
        }
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $filialen);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
