<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Organisation;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'organisation uid', true);
        $this->registerArgument('as', 'string', 'name for organisation object ', true);
    }
    
    public function render(): string
    {
        $organisationRepository = GeneralUtility::makeInstance(OrganisationRepository::class);
        $organisationUid = $this->arguments['uid'];
        $organisation = $organisationRepository->findByUid($organisationUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $organisation);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
