<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Person;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ListViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('frontendUserUid', 'int', 'frontendUser uid', true);
        $this->registerArgument('as', 'string', 'name for contact objects', true);
    }

    public function render(): string
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        $frontendUserUid = $this->arguments['frontendUserUid'];
        $contacts = $personRepository->findByFrontendUser($frontendUserUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $contacts);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
