<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Person;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'person uid', true);
        $this->registerArgument('as', 'string', 'name for person object ', true);
    }

    public function render(): string
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        $personUid = $this->arguments['uid'];
        $person = $personRepository->findByUid($personUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $person);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
