<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Person;

use Closure;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

//use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithContentArgumentAndRenderStatic;

class VerbandViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    //\TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper {

    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('person', Contact::class, 'Contact: Person/Organisation', true);
        $this->registerArgument('verband', 'mixed', 'Verband', true);
        //$this->registerArgument('verband', Verband::class .'|int', 'Verband', true);
        $this->registerArgument('as', 'string', 'contactVerband', false, 'contactVerband');
    }

    public function render(): string
    {
        $person = $this->arguments['person'];
        $verband = $this->arguments['verband'];
        $verbandUid = is_object($verband) ? $verband->getUid() : (int) $verband;
        //$templateVariableContainer=$this->renderingContext->getVariableProvider();
        $contactVerband = $person->getContactVerbandById($verbandUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $contactVerband);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
        //. '::as=' . $this->arguments['as'] .'('.$person->getUid(). ','. $verband->getUid().'='.( $contactVerband ? $contactVerband->getVerband()->getUid() : '').')';
    }
}
