<?php

namespace Internetgalerie\IgsCrm\ViewHelpers;

use Closure;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ReplaceTagsViewHelper extends AbstractViewHelper
{
    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        //$this->registerArgument('value', 'string', 'source', true);
        $this->registerArgument('person', Contact::class, 'Person', false);
        $this->registerArgument('objects', 'array', 'array of Objects');
    }

    public function render(): string
    {
        $output = $this->renderChildren();
        //$html =$this->arguments['value'];
        $person = $this->arguments['person'];
        $objects = $this->arguments['objects'];
        $output = str_replace('[[person.titelName]]', $person->getTitelName(), $output);
        $output = str_replace('[[person.name]]', $person->getName(), $output);
        $output = str_replace('[[person.strasse]]', $person->getAddress(), $output);
        $output = str_replace('[[person.plzort]]', $person->getZip() . ' ' . $person->getCity(), $output);
        $output = str_replace('[[person.plz]]', $person->getZip(), $output);
        $output = str_replace('[[person.city]]', $person->getCity(), $output);

        return $output;
    }
}
