<?php

namespace Internetgalerie\IgsCrm\ViewHelpers;

use Closure;
use Internetgalerie\IgCrmTemplate\Utility\CrmTranslate;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TranslateViewHelper extends AbstractViewHelper
{
    /**
     * Initialize the arguments.
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        //$this->registerAsArgument();
        $this->registerArgument(
            'languageKey',
            'string',
            'Key for getting translation of a different than current initialized language',
            false,
            null
        );
        $this->registerArgument('key', 'string', 'translation key', false, null);
    }

    public function render(): string
    {
        return CrmTranslate::translate($this->arguments['key'], $this->arguments['languageKey']);
    }
}
