<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Verband;

use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IfHasAclReadViewHelper extends AbstractConditionViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('verband', Verband::class, 'verband', true);
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $verband = $arguments['verband'];
        if (!$verband instanceof Verband) {
            return false;
        }

        $securityUtility = GeneralUtility::makeInstance(SecurityUtility::class);
        return $securityUtility->hasPermissionRead($verband, 'crm.tenant');
    }
}
