<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Verband;

use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateLetterRepository;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IfHasTemplateLetterViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('client', Verband::class, 'verband', true);
        $this->registerArgument('objectType', 'string', 'objectType', false, null);
        $this->registerArgument('templateType', 'string', 'templateType', false, null);
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $client = $arguments['client'];
        if (!$client instanceof Verband) {
            return false;
        }

        $templateType = $arguments['templateType'];
        $objectType = $arguments['objectType'];

        $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);

        $templateLetters = $templateLetterRepository->findByVerbandType(
            $client->getUid(),
            $templateType,
            null,
            $objectType
        );
        return is_array($templateLetters) ? count($templateLetters) : false;
    }
}
