<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Verband;

use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\ContactVerband;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IfIsMemberViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('verband', 'int', 'verband uid', true);
        $this->registerArgument('person', Contact::class, 'Person/Person', true);
    }
    
    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $person = $arguments['person'];
        $verbandUid = $arguments['verband']; // $verband->getUid()
        //$templateVariableContainer=$this->renderingContext->getVariableProvider();
        $contactVerband = $person->getContactVerbandById($verbandUid);
        return $contactVerband instanceof ContactVerband ? $contactVerband->getActive() : false;
    }
}
