<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Verband;

use Closure;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'verband uid', true);
        $this->registerArgument('as', 'string', 'name for verband object ', true);
    }

    public function render(): string
    {
        $verbandRepository = GeneralUtility::makeInstance(VerbandRepository::class);
        $verbandUid = $this->arguments['uid'];
        $verband = $verbandRepository->findByUid($verbandUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $verband);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
