<?php

namespace Internetgalerie\IgsCrm\ViewHelpers\Verband;

use Closure;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateLetterRepository;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TemplateLetterViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('client', Verband::class, 'verband', true);
        $this->registerArgument('objectType', 'string', 'objectType', false, null);
        $this->registerArgument('templateType', 'string', 'templateType', false, null);
        $this->registerArgument('favorite', 'bool', 'favorite', false, null);
        $this->registerArgument('as', 'string', 'name for verband object ', true);
    }

    public function render(): string
    {
        $client = $this->arguments['client'];
        if (!$client instanceof Verband) {
            return false;
        }
        
        $templateType = $this->arguments['templateType'];
        $objectType = $this->arguments['objectType'];
        $favorite = $this->arguments['favorite'];
        
        $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);

        if ($favorite) {
            $templateLetters = $templateLetterRepository->findFavoritesByVerbandType(
                $client->getUid(),
                $templateType,
                $objectType
            );
        } else {
            $templateLetters = $templateLetterRepository->findByVerbandType(
                $client->getUid(),
                $templateType,
                null,
                $objectType
            );
        }
        
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $templateLetters);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
