<?php

use Ig\IgFibu\Domain\Model\Invoice;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceAnnual;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Model\InvoiceItemUnit;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemMembership;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemJournal;
use Internetgalerie\IgsCrm\Domain\Model\FrontendUser;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\Person;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;

return [
    Invoice::class => [
        'tableName' =>  'tx_igfibu_domain_model_invoice',
        'recordType' => Invoice::class,
        'subclasses' => [
            'Invoice' => \Internetgalerie\IgsCrm\Domain\Model\Invoice::class,
            'InvoiceAnnual' => InvoiceAnnual::class,
        ],
    ],
    
    \Internetgalerie\IgsCrm\Domain\Model\Invoice::class => [
        'tableName' => 'tx_igfibu_domain_model_invoice',
        'recordType' => 'Invoice',
    ],
    InvoiceAnnual::class => [
        'tableName' => 'tx_igfibu_domain_model_invoice',
        'recordType' => 'InvoiceAnnual',
    ],
    

    InvoiceItem::class => [
        'tableName' =>  'tx_igfibu_domain_model_invoiceitem',
        'recordType' => InvoiceItem::class,
        'subclasses' => [
            InvoiceItem::class => InvoiceItem::class,
            InvoiceItemUnit::class => InvoiceItemUnit::class,
            InvoiceItemMembership::class => InvoiceItemMembership::class,
            InvoiceItemJournal::class => InvoiceItemJournal::class,
        ],
    ],

    InvoiceItemMembership::class => [
        'tableName' => 'tx_igfibu_domain_model_invoiceitem',
        'recordType' => InvoiceItemMembership::class,
    ],

    InvoiceItemJournal::class => [
        'tableName' => 'tx_igfibu_domain_model_invoiceitem',
        'recordType' => InvoiceItemJournal::class,
    ],


    FrontendUser::class => [
        'tableName' => 'fe_users',
        'properties' => [
            'originalFileIdentifier' => [
                'crmSettingsPrinterMarginTop' => 'crm_settings_printer_margin_top',
                'crmSettingsCustomCss' => 'crm_settings_custom_css',
                'crmVerbandUids' => 'crm_verband_uids',
            ],
        ],
    ],
    
    Contact::class => [
        'tableName' =>  'tx_igscrm_domain_model_contact',
        'recordType' => 'Contact',
        'subclasses' => [
            'Person' => Person::class,
            'Organisation' => Organisation::class,
        ],
    ],
    Person::class => [
        'tableName' =>  'tx_igscrm_domain_model_contact',
        'recordType' => 'Person',
        //'subclasses' => [
            //'Organisation' => \Internetgalerie\IgsCrm\Domain\Model\Organisation::class,
        // ],
    ],
     Organisation::class => [
        'tableName' =>  'tx_igscrm_domain_model_contact',
        'recordType' => 'Organisation',//\Internetgalerie\IgsCrm\Domain\Model\Organisation::class,
     ],

];
