<?php

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

call_user_func(function () {

    $newColumn = [
        'crm_settings_printer_margin_top' => [
            'exclude' => 0,
            'label' => 'Drucker Abstand Oben',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'Normaler Abstand (0)', 'value' => 0],
                    ['label' => 'Kleiner Abstand (30)', 'value' => 30],
                    ['label' => 'Mittlerer Abstand (60)', 'value' => 60],
                    ['label' => 'Mittel-Grosser Abstand (75)', 'value' => 75],
                ],
            ],
        ],
        'crm_settings_custom_css' => [
            'exclude' => 0,
            'label' => 'Zusätzliche CSS Regeln',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15
            ],
        ],

        'crm_verband_uids' => [
            'exclude' => 0,
            'label' => 'Verband Uids to show in person list',
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
                'nullable' => true,
            ],
        ],
        'crm_default_group' => [
            'exclude' => 0,
            'label' => 'ACL: Default Frontend Usergroup',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'fe_groups',
                'items' => [
                    ['label' => '', 'value' => '0'],
                ],
            ],
        ],

    ];
    ExtensionManagementUtility::addTCAcolumns('fe_users', $newColumn);

    ExtensionManagementUtility::addToAllTCAtypes(
        'fe_users',
        'crm_settings_printer_margin_top, crm_settings_custom_css, crm_verband_uids,crm_default_group'
    );
});
