<?php

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemMembership;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemJournal;

call_user_func(function () {

    $newColumn = [
        'membership' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.membership',
            'config' => [
                'type' => 'number',
                'size' => 30
            ]
        ],
        'journal' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.journal',
            'config' => [
                'type' => 'number',
                'size' => 30
            ]
        ],

    ];
    ExtensionManagementUtility::addTCAcolumns('tx_igfibu_domain_model_invoiceitem', $newColumn);


    // add new type (addToAllTCAtypes only works for existing types as  of TYPO3 11.5.19)
    $GLOBALS['TCA']['tx_igfibu_domain_model_invoiceitem']['types'][InvoiceItemMembership::class] = ['showitem' => 'type'];
    $GLOBALS['TCA']['tx_igfibu_domain_model_invoiceitem']['types'][InvoiceItemJournal::class] = ['showitem' => 'type'];
    
    // add field only to type InvoiceItemMembership
    ExtensionManagementUtility::addToAllTCAtypes(
        'tx_igfibu_domain_model_invoiceitem',
        'membership, description, amount, tax_behavior, tax_rate, cost_center',
        InvoiceItemMembership::class, // type to add
    );
    ExtensionManagementUtility::addToAllTCAtypes(
        'tx_igfibu_domain_model_invoiceitem',
        'journal, description, amount, tax_behavior, tax_rate, cost_center',
        InvoiceItemJournal::class, // type to add
    );

    /**
     * also add type to pulldown in tx_igfibu_domain_model_costcenter.invoiceitem_types
     */

    // add type InvoiceItemMembership to type pulldown in backend
    ExtensionManagementUtility::addTcaSelectItem(
        'tx_igfibu_domain_model_invoiceitem',
        'type',
        ['LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.membership', InvoiceItemMembership::class]
    );
    // add type InvoiceItemMembership to type pulldown in backend
    ExtensionManagementUtility::addTcaSelectItem(
        'tx_igfibu_domain_model_invoiceitem',
        'type',
        ['LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.journal', InvoiceItemJournal::class]
    );

    
});
