<?php

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Resource\File;

$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
if ($versionInformation->getMajorVersion() > 11) {
    $backgroundImageEvenConfig = $backgroundImageOddConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igscrm_domain_model_card',
        ],
        'maxitems' => 1,
        'allowed' => 'common-image-types',

    ];
} else {
    $backgroundImageOddConfig = [
        ### !!! Watch out for fieldName different from columnName
        'type' => 'file',
        'allowed' => $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext'],
        'appearance' => [
            'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
        ],
        'foreign_types' => [
            '0' => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_TEXT => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_IMAGE => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_AUDIO => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_VIDEO => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_APPLICATION => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ]
        ],
        'foreign_match_fields' => [
            'fieldname' => 'background_image_odd',
            'tablenames' => 'tx_igscrm_domain_model_card',
        ],
        'maxitems' => 1,
    ];
    $backgroundImageEvenConfig = [
        ### !!! Watch out for fieldName different from columnName
        'type' => 'file',
        'allowed' => $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext'],
        'appearance' => [
            'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
        ],
        'foreign_types' => [
            '0' => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_TEXT => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_IMAGE => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_AUDIO => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_VIDEO => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_APPLICATION => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ]
        ],
        'foreign_match_fields' => [
            'fieldname' => 'background_image_even',
            'tablenames' => 'tx_igscrm_domain_model_card',
        ],
        'maxitems' => 1,
    ];
}

return [
    'ctrl' => [
        'title' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card',
        'label' => 'title',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'title,field1_label,field1_value,field2_label,field2_value,field3_label,field3_value,back_text,letter_title,letter_text,letter_new_title,letter_new_text',
        'iconfile' => 'EXT:igs_crm/Resources/Public/Icons/tx_igscrm_domain_model_card.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, title, period, field1_label, field1_value, field2_label, field2_value, field3_label, field3_value, back_text, background_image, background_image_even, letter_title, letter_text, letter_new_title, letter_new_text, enable_wallet, letter_closing, verband, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language'],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igscrm_domain_model_card',
                'foreign_table_where' => 'AND {#tx_igscrm_domain_model_card}.{#pid}=###CURRENT_PID### AND {#tx_igscrm_domain_model_card}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'period' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field1_label',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'field1_label' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field1_label',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'field1_value' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field1_value',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'field2_label' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field2_label',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'field2_value' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field2_value',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'field3_label' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field3_label',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'field3_value' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.field3_value',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'back_text' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.back_text',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],

        ],
        'background_image_odd' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.background_image_odd',
            'config' => $backgroundImageOddConfig,
        ],
        'background_image_even' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.background_image_even',
            'config' => $backgroundImageEvenConfig,
        ],
        'letter_title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.letter_title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'letter_text' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.letter_text',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],

        ],
        'letter_new_title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.letter_new_title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'letter_new_text' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.letter_new_text',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],

        ],
        'enable_wallet' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.enable_wallet',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
            ],
        ],

        'letter_closing' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.letter_closing',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],
        ],
        'verband' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igscrm_domain_model_card.verband',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igscrm_domain_model_verband',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],

    ],
];
